import Program

class Ingredient:
    """
    Purpose:
        Class is used for every known ingredient to be able to access or modify
        ingredient information easily
    Instance variables:
        Ingredient.ingredients_dict: dictionary of all ingredients in the format of
            {"name": ingredient_object}
        self.name: name of ingredient
        self.cost: cost of ingredient
        self.unit: unit that the cost is based on. Either "Unit" or "Oz". For example
            Eggs would be "Unit" and Vanilla would be "Oz"
        self.recipes: Set of all recipe names that the ingredient is used in
    Methods:
        update_recipe_cost: recalculates the cost of every recipe that uses
            the ingredient. This is used if the cost of the ingredient changes
        __str__: creates a string of the ingredient and its information to be saved in
            a csv file.
    """

    ingredients_dict = {}

    def __init__(self, name, cost, unit, recipes={}) -> None:
        self.name = name
        self.cost = cost
        self.unit = unit
        self.recipes = set(recipes)
        Ingredient.ingredients_dict[self.name] = self

    def update_recipes_cost(self):
        for recipe in tuple(self.recipes):
            Program.Program.search_recipe_name(recipe).update_cost()

    def __repr__(self):
        return f"{self.name}_ingredient_object"

    def __str__(self):
        return (
            ",".join(
                [
                    '"' + str(x).replace('"', '""') + '"'
                    if "," in str(x) or '"' in str(x)
                    else str(x)
                    for x in [self.name, str(self.cost), self.unit, str(self.recipes)]
                ]
            )
            + "\n"
        )


# ingredients: dict of string name ingredient as key and amount of ingredient as value {Eggs: [3, 'Unit']}